package jp.mosp.common.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmComponentDto;

public abstract class MosPMenuArrangeVo extends MosPVo {

	// 萔
	public static final int SEARCH_OFF = 0;
	public static final int SEARCH_ON  = 1;

	public static final int MODE_INSERT = 0;
	public static final int MODE_UPDATE = 1;

	// p[^[
	public static final String PRM_TXT_COMP_CODE  = "txtCompCode"	;
	public static final String PRM_TXT_COMP_NAME  = "txtCompName"	;
	public static final String PRM_PLT_MANAGE  	= "pltManage"	;
	public static final String PRM_PLT_SELECTED	= "pltSelected"	;
	public static final String PRM_PLT_DELETE		= "pltDelete"	;

	// tB[h
	private String		txtCompCode		;
	private String   	txtCompName		;
	private String   	hidDivision		;
	private String   	pltManage  		;
	private	 String[]	pltSelected		;
	private String		pltDelete		;

	private String[]	aryCompCode	;
	private String[]	aryCompName	;
	private String[]	aryManage	;
	private String[]	aryComponent;
	private String[]	aryDelete	;

	// [h(0FVKo^A1FXV)
	private int mode;

	// [h(0FȂA1F)
	private int searchmode;

	// tB[hyѐ
	public static final String NAM_COMP_CODE 		= CommonConst.NAM_COMMON_CODE		;
	public static final String NAM_COMP_NAME 		= CommonConst.NAM_COMMON_MEISYO		;
	public static final String NAM_MANAGE			= CommonConst.NAM_MANAGE			;
	public static final String NAM_COMPONENT		= CommonConst.NAM_COMPONENT			;
	public static final String NAM_PLT_SELECTED	= CommonConst.NAM_PLT_SELECTED		;
	public static final String NAM_DELETE			= CommonConst.NAM_DELETE_FLAG		;

	public static final String NAM_EMPLOYEE_CMD	= CommonConst.NAM_EMPLOYEE_CMD		;
	public static final String NAM_MANAGER_CMD		= CommonConst.NAM_MANAGER_CMD		;
	public static final String NAM_PAYROLL_CMD		= CommonConst.NAM_PAYROLL_CMD		;
	public static final String NAM_HUMAN_CMD		= CommonConst.NAM_HUMAN_CMD			;

	public static final int LEN_CODE		= 10;
	public static final int LEN_NAME		= 10;
	public static final String	 REG_DELETE = CommonConst.REG_DELETE;

	// v_EXg
	public String[][] aryPltManage;
	public String[][] aryPltCmdItem;
	public String[][] arySelectedCmdItem;

	// \[gL[
	public final String KEY_COMP_CODE 	= "keyCompCode";
	public final String KEY_COMP_NAME 	= "keyCompName";
	public final String KEY_MANAGE 	= "keyManage";
	public final String KEY_COMPONENT 	= "keyComponent";
	public final String KEY_DELETE 	= "keyDelete";

	public MosPMenuArrangeVo() {
		super();
		this.txtCompCode = "";
		this.txtCompName = "";
		this.hidDivision = "";
		this.pltManage = "";
		this.pltSelected = new String[0];
		this.pltDelete = "";
		this.aryCompCode = new String[0];
		this.aryCompName = new String[0];
		this.aryManage = new String[0];
		this.aryComponent = new String[0];
		this.aryDelete = new String[0];
		this.mode = MODE_INSERT;
		this.searchmode = SEARCH_OFF;
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setCardParams(HttpServletRequest request) {
		txtCompCode		= request.getParameter(PRM_TXT_COMP_CODE);
		txtCompName    	= request.getParameter(PRM_TXT_COMP_NAME);
		pltManage		= request.getParameter(PRM_PLT_MANAGE);
		pltSelected 	= request.getParameterValues(PRM_PLT_SELECTED);
		pltDelete 		= request.getParameter(PRM_PLT_DELETE);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setListParams(HttpServletRequest request) {
		txtCompCode 	= request.getParameter(PRM_TXT_COMP_CODE);
		txtCompName  	= request.getParameter(PRM_TXT_COMP_NAME);
		pltManage 		= request.getParameter(PRM_PLT_MANAGE);
		pltDelete  		= request.getParameter(PRM_PLT_DELETE);	
	}

	/**
	 * tB[hݒ
	 * @param dto [U[Xg
	 */
	public void setFields(CmComponentDto dto) {
		txtCompCode		= dto.getCompCode();
		txtCompName		= dto.getCompName();
		pltManage		= String.valueOf(dto.getManage());
		pltSelected		= util.divideByComma(dto.getComponent());
		pltDelete		= String.valueOf(dto.getDeleteFlag());		
	}

	/**
	 * tB[hݒ
	 * @param listHumanComp	lj[Xg
	 */
	public void setFields(List list) {
		// Xg̐ݒ
		this.list = list;
		// f[^̎擾
		count = list.size();
		// z̏
		aryCompCode		= new String[count];
		aryCompName		= new String[count];
		aryManage		= new String[count];
		aryComponent	= new String[count];
		aryDelete		= new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = list.iterator();
		while (it.hasNext()) {
			CmComponentDto dto = (CmComponentDto)it.next();
			aryCompCode[i]	= escapeHTML(dto.getCompCode());
			aryCompName[i]	= escapeHTML(dto.getCompName());
			aryManage[i]	= escapeHTML(getCodeName(String.valueOf(dto.getManage()), aryPltManage));
			aryComponent[i]	= escapeHTML(getCmdNameList(dto.getComponent(), aryPltCmdItem));
			if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_OFF) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_OFF_NAME);
			} else if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_ON) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_ON_NAME);
			}
			i++;
		}
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(CmComponentDto dto) {
		dto.setDivision		(hidDivision);
		dto.setCompCode		(txtCompCode);
		dto.setCompName		(txtCompName);
		dto.setManage		(Integer.parseInt(pltManage));
		dto.setComponent	(util.combineByComma(pltSelected));
		dto.setDeleteFlag	(Integer.parseInt(pltDelete));
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtCompCode	, NAM_COMP_CODE	, PRM_TXT_COMP_CODE);
		checkRequired(txtCompName	, NAM_COMP_NAME	, PRM_TXT_COMP_NAME);
		// 񒷊mF
		checkLength(txtCompCode	, LEN_CODE	, NAM_COMP_CODE	, PRM_TXT_COMP_CODE);
		checkLength(txtCompName	, LEN_NAME	, NAM_COMP_NAME	, PRM_TXT_COMP_NAME);
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		sb.append("var DEFAULT_CODE = \"");
		sb.append(hidDivision);
		sb.append("\";");
		if (mode == MODE_UPDATE) {
			sb.append(getArrayJs("ARY_SELECTED", arySelectedCmdItem));			
		}
		return sb.toString();
	}

	/**
	 * R}ḧꗗ
	 * @param component			ΏۃR}hꗗ
	 * @param aryPltCmdItem		ΏۃR}hz
	 * @return
	 */
	protected String getCmdNameList(String component, String[][] aryPltCmdItem) {
		String [] aryCmd = util.divideByComma(component);
		StringBuffer sb = new StringBuffer();
		for (int j = 0 ; j < aryCmd.length; j++) {
			sb.append(getCodeName(aryCmd[j], aryPltCmdItem));
			if (j != aryCmd.length - 1) {
				sb.append(CommonConst.KEY_SEPARATOR);
			}
		}
		return sb.toString();
	}

	// ANZT\bh
	public String[] getPltSelected() { return pltSelected == null ? null : pltSelected.clone(); }

	public String getTxtCompCode	() 	{ return txtCompCode	; }
	public String getTxtCompName	()	{ return txtCompName	; }
	public String getPltManage		() 	{ return pltManage		; }
	public String getPltDelete		()	{ return pltDelete		; }

	public String getEscTxtCompCode	() { return escapeHTML(txtCompCode)	; }
	public String getEscTxtCompName	() { return escapeHTML(txtCompName)	; }

	public void setTxtCompCode		(String txtCompCode	) { this.txtCompCode 	= txtCompCode	; }
	public void setTxtCompName		(String txtCompName	) { this.txtCompName	= txtCompName	; }
	public void setPltManage		(String pltManage	) { this.pltManage		= pltManage		; }
	public void setPltDelete		(String pltDelete	) { this.pltDelete 		= pltDelete		; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

	public String getHidDivision() { return hidDivision; }
	public void setHidDivision(String hidDivision) { this.hidDivision = hidDivision; }

	public String[] getEscAryCompCode	() { return aryCompCode.clone()		; }
	public String[] getEscAryCompName	() { return aryCompName.clone()		; }
	public String[] getEscAryManage		() { return aryManage.clone()		; }
	public String[] getEscAryComponent	() { return aryComponent.clone()	; }
	public String[] getEscAryDelete		() { return aryDelete.clone()		; }

	public void setSearchmode(int searchmode) { this.searchmode = searchmode; }
	public int getSearchmode() { return searchmode; }

}
